In addition to allowing custom shells to be specified for individual commands, Bonnie also allows the specification of default shells for different OSes on a per-file basis. This is controlled by the `default_shell` top-level property (placed next to `version` and `env_files`).

## Simple syntax

The simplest syntax you can use is just a key-value pair that specifies a universal default shell. This is not recommended due to its lack of cross-platform capability (e.g. many Windows users won't have `bash`).

```toml
default_shell = [ "bash", "-c", "{COMMAND}" ]
```

As with custom shells for individual commands, `default_shell` expects an array for its shell, with `{COMMAND}` being the location to insert the command. This syntax is covered in depth [here](./Custom-Shells).

## Complex syntax

The far more useful syntax is nearly identical to that for individual commands (see [here](./Custom-Shells)), mandating the use of a `.generic` property for a fallback shell, and then allowing a list of targets to be defined under `.targets`.

```toml
default_shell.generic = [ "sh", "-c", "{COMMAND}" ]
default_shell.targets.windows = [ "powershell", "-command", "{COMMAND}" ]
default_shell.targets.macos = [ "sh", "-c", "{COMMAND}" ]
default_shell.targets.linux = [ "sh", "-c", "{COMMAND}" ]
```

The above example uses the global defaults that will be used if you don't specify any default shells. These are automatic unless you specify `default_shell` **in any way**, then `.generic` will be used (or the universal value, if you use simple syntax).

Note that the default shell can specify delimiters just as normal shells can. The default for any given default shell will be `&&`. You can read more about that [here](./Custom-Shells).

Please note that the default shell on Windows is Windows PowerShell since v0.3.0. This can be changed on a per-file basis by setting the Windows default shell to `[ "cmd", "/C", "{COMMAND}" ]`.
